﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

/// Includes ---------------------------------

// nkInputs
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkImages
{
	class DLL_IMAGES_EXPORT LogManager final : public nkCommon::SingletonClass<LogManager>
	{
		public :

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Log
			void log (nkMemory::StringView message, nkMemory::StringView className) ;

		private :

			// Registered logger
			nkLog::Logger* _receiver ;

		private :

			// Constructor, destructor
			LogManager () noexcept ;
			virtual ~LogManager () ;

		private :

			friend class nkCommon::SingletonClass<LogManager> ;
	} ;
}